import org.serviio.library.online.WebResourceUrlExtractor
import org.serviio.library.online.WebResourceContainer
import org.serviio.library.online.ContentURLContainer
import org.serviio.library.online.WebResourceItem
import org.serviio.library.online.PreferredQuality
import org.serviio.library.metadata.MediaFileType
/**
 * WebResource extractor Serviio plugin for xvideos.com <br/>
 * <b>version</b> 1.0
 *
 * @author Michael Mishalov
 * @since JDK 1.6, Groovy 1.8.6
 */
class XVIDEOS extends WebResourceUrlExtractor{
    ////////////////////////////////////////////[Constants]////////////////////////////////////////////
    final static VALID_WEB_RESOURCE_URL                     = '^(?:http?://)?(?:www\\.)?xvideos.com/.*'
    final static DEFAULT_VIDEO_DOMAIN                       = "http://xvideos.com"
    final static USER_AGENT                                 = 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.835.186 Safari/535.1'
    final static HREF_REGEX                                 = /(?s)<a href="(.*?)">/
    final static THUMBNAIL_REGEX                            = /(?s) id="tabVote">(.*)<img src="(.*?)" height="24"/
    final static VIDEO_REGEX                                = /(?s)flv_url=(.*?)&amp;/
    final static VIDEO_URL_PREFIX                           = "/video";
    /////////////////////////////////////////////[Methods]/////////////////////////////////////////////
    @Override
    protected WebResourceContainer extractItems(URL url, int i) {
        def videoURLsSet = reprieveURLs(url);
        return new WebResourceContainer(title: url.toString(), items: reprieveURLs(url))
    }
    List<WebResourceItem> reprieveURLs(URL url) {
        Set<String> pages = new HashSet<String>();
        List<WebResourceItem> items = []
        String pageSource = openURL(url, USER_AGENT)
        String candidate;
        (pageSource=~HREF_REGEX).each {
            candidate = (it-null)[-1];
            if(candidate.startsWith(VIDEO_URL_PREFIX)){
                if(!pages.contains(candidate)){
                    pages.add(candidate);
                    Map<String,String> additionalInfo = new HashMap<String, String>();
                    additionalInfo.put("videoURL",DEFAULT_VIDEO_DOMAIN + candidate)
                    String title = ((pageSource=~String.format(/(?s)<p><a href="%s">(.*?)<\/a>/,candidate))[0]-null)[-1].toString().trim()
                    items << new WebResourceItem(title: title, additionalInfo: additionalInfo)
                }
            }
        }
        return items;
    }
    @Override
    protected ContentURLContainer extractUrl(WebResourceItem webResourceItem, PreferredQuality preferredQuality) {
        URL videoPageURL = new URL(webResourceItem.getAdditionalInfo().get("videoURL"))
        log(String.format("[%s] Staring video URL extraction for %s",getExtractorName(),videoPageURL))
        ContentURLContainer contentURLContainer = new ContentURLContainer();
        try{
            fillURLContainer(videoPageURL,contentURLContainer)
            return contentURLContainer
        }catch (IndexOutOfBoundsException e){
            log.error(String.format("%s , Filed to create resource item for URL: %s",getExtractorName(), it), log.isDebugEnabled()? e:null)
        }
        return null
    }
     void fillURLContainer (URL url,ContentURLContainer contentURLContainer) {
        String pageSource = openURL(url, USER_AGENT)
        contentURLContainer.setThumbnailUrl(((pageSource=~THUMBNAIL_REGEX)[0]-null)[-1].toString().trim())
        contentURLContainer.setContentUrl(new URLDecoder().decode(((pageSource=~VIDEO_REGEX)[0]-null)[-1].toString().trim()))
    }
    @Override
    boolean extractorMatches(URL url) {
        return url ==~ VALID_WEB_RESOURCE_URL
    }

    @Override
    String getExtractorName() {
        return getClass().getName()
    }
    static void main(args) {
        def TestUrl = new URL("http://www.xvideos.com/c/5/teen-13")
        XVIDEOS extractor = new XVIDEOS()
        WebResourceContainer container = extractor.extractItems(TestUrl, -1);
        println "PluginName               : " + extractor.getExtractorName();
        println "TestMatch                : " + extractor.extractorMatches(TestUrl);
        container.getItems().each {
            println "URL                  : " + extractor.extractUrl(it, PreferredQuality.HIGH)
        }
    }
}
